/*
 * File: FunGraphics.java
 * -----------------------
 * This program shows some examples of having
 * fun with a GraphicsProgram.
 */


/* Packages being imported */
import acm.graphics.*;	// Needed for GraphicsProgram
import acm.program.*;	// Needed for all Programs
import java.awt.*;		// Needed for Colors


public class FunGraphics extends GraphicsProgram {
	/* Constants defining parameters of the oval. */
	private static final double OVAL_Y = 20;
	private static final double OVAL_WIDTH = 100;
	private static final double OVAL_HEIGHT = 200;
	
	public void run() {	
		double x = (getWidth() - OVAL_WIDTH) / 2.0;
		
		/* Create a background for the oval. */
		GRect rect = new GRect(x, OVAL_Y, OVAL_WIDTH, OVAL_HEIGHT);
		rect.setFilled(true);
		add(rect);
		
		/* Create our artistic rendition of the Stanford Oval. */
		GOval theOval = new GOval(x, OVAL_Y, OVAL_WIDTH, OVAL_HEIGHT);
		theOval.setFilled(true);
		theOval.setColor(Color.RED);
		theOval.setFillColor(Color.GREEN);
		add(theOval);
	}
}
